package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SubjectRightsRequestStage implements Enum {

    @JsonProperty("contentRetrieval")
    CONTENT_RETRIEVAL("contentRetrieval", "0"),

    @JsonProperty("contentReview")
    CONTENT_REVIEW("contentReview", "1"),

    @JsonProperty("generateReport")
    GENERATE_REPORT("generateReport", "2"),

    @JsonProperty("contentDeletion")
    CONTENT_DELETION("contentDeletion", "3"),

    @JsonProperty("caseResolved")
    CASE_RESOLVED("caseResolved", "4"),

    @JsonProperty("contentEstimate")
    CONTENT_ESTIMATE("contentEstimate", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private SubjectRightsRequestStage(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
