package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SubjectAlternativeNameType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("emailAddress")
    EMAIL_ADDRESS("emailAddress", "1"),

    @JsonProperty("userPrincipalName")
    USER_PRINCIPAL_NAME("userPrincipalName", "2"),

    @JsonProperty("customAzureADAttribute")
    CUSTOM_AZURE_ADATTRIBUTE("customAzureADAttribute", "4"),

    @JsonProperty("domainNameService")
    DOMAIN_NAME_SERVICE("domainNameService", "8"),

    @JsonProperty("universalResourceIdentifier")
    UNIVERSAL_RESOURCE_IDENTIFIER("universalResourceIdentifier", "16");

    private final String name;
    private final String value;

    private SubjectAlternativeNameType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
