package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SimulationAttackTechnique implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("credentialHarvesting")
    CREDENTIAL_HARVESTING("credentialHarvesting", "1"),

    @JsonProperty("attachmentMalware")
    ATTACHMENT_MALWARE("attachmentMalware", "2"),

    @JsonProperty("driveByUrl")
    DRIVE_BY_URL("driveByUrl", "3"),

    @JsonProperty("linkInAttachment")
    LINK_IN_ATTACHMENT("linkInAttachment", "4"),

    @JsonProperty("linkToMalwareFile")
    LINK_TO_MALWARE_FILE("linkToMalwareFile", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private SimulationAttackTechnique(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
