package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SignInIdentifierType implements Enum {

    @JsonProperty("userPrincipalName")
    USER_PRINCIPAL_NAME("userPrincipalName", "0"),

    @JsonProperty("phoneNumber")
    PHONE_NUMBER("phoneNumber", "1"),

    @JsonProperty("proxyAddress")
    PROXY_ADDRESS("proxyAddress", "2"),

    @JsonProperty("qrCode")
    QR_CODE("qrCode", "3"),

    @JsonProperty("onPremisesUserPrincipalName")
    ON_PREMISES_USER_PRINCIPAL_NAME("onPremisesUserPrincipalName", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private SignInIdentifierType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
