package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SettingSourceType implements Enum {

    @JsonProperty("deviceConfiguration")
    DEVICE_CONFIGURATION("deviceConfiguration", "0"),

    @JsonProperty("deviceIntent")
    DEVICE_INTENT("deviceIntent", "1");

    private final String name;
    private final String value;

    private SettingSourceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
