package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ServiceHealthStatus implements Enum {

    @JsonProperty("serviceOperational")
    SERVICE_OPERATIONAL("serviceOperational", "0"),

    @JsonProperty("investigating")
    INVESTIGATING("investigating", "1"),

    @JsonProperty("restoringService")
    RESTORING_SERVICE("restoringService", "2"),

    @JsonProperty("verifyingService")
    VERIFYING_SERVICE("verifyingService", "3"),

    @JsonProperty("serviceRestored")
    SERVICE_RESTORED("serviceRestored", "4"),

    @JsonProperty("postIncidentReviewPublished")
    POST_INCIDENT_REVIEW_PUBLISHED("postIncidentReviewPublished", "5"),

    @JsonProperty("serviceDegradation")
    SERVICE_DEGRADATION("serviceDegradation", "6"),

    @JsonProperty("serviceInterruption")
    SERVICE_INTERRUPTION("serviceInterruption", "7"),

    @JsonProperty("extendedRecovery")
    EXTENDED_RECOVERY("extendedRecovery", "8"),

    @JsonProperty("falsePositive")
    FALSE_POSITIVE("falsePositive", "9"),

    @JsonProperty("investigationSuspended")
    INVESTIGATION_SUSPENDED("investigationSuspended", "10"),

    @JsonProperty("resolved")
    RESOLVED("resolved", "11"),

    @JsonProperty("mitigatedExternal")
    MITIGATED_EXTERNAL("mitigatedExternal", "12"),

    @JsonProperty("mitigated")
    MITIGATED("mitigated", "13"),

    @JsonProperty("resolvedExternal")
    RESOLVED_EXTERNAL("resolvedExternal", "14"),

    @JsonProperty("confirmed")
    CONFIRMED("confirmed", "15"),

    @JsonProperty("reported")
    REPORTED("reported", "16"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "17");

    private final String name;
    private final String value;

    private ServiceHealthStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
