package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ServiceHealthOrigin implements Enum {

    @JsonProperty("microsoft")
    MICROSOFT("microsoft", "1"),

    @JsonProperty("thirdParty")
    THIRD_PARTY("thirdParty", "2"),

    @JsonProperty("customer")
    CUSTOMER("customer", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private ServiceHealthOrigin(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
