package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ScheduledRetireState implements Enum {

    @JsonProperty("cancelRetire")
    CANCEL_RETIRE("cancelRetire", "0"),

    @JsonProperty("comfirmRetire")
    COMFIRM_RETIRE("comfirmRetire", "1");

    private final String name;
    private final String value;

    private ScheduledRetireState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
