package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RiskState implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("confirmedSafe")
    CONFIRMED_SAFE("confirmedSafe", "1"),

    @JsonProperty("remediated")
    REMEDIATED("remediated", "2"),

    @JsonProperty("dismissed")
    DISMISSED("dismissed", "3"),

    @JsonProperty("atRisk")
    AT_RISK("atRisk", "4"),

    @JsonProperty("confirmedCompromised")
    CONFIRMED_COMPROMISED("confirmedCompromised", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private RiskState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
