package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RiskDetectionTimingType implements Enum {

    @JsonProperty("notDefined")
    NOT_DEFINED("notDefined", "0"),

    @JsonProperty("realtime")
    REALTIME("realtime", "1"),

    @JsonProperty("nearRealtime")
    NEAR_REALTIME("nearRealtime", "2"),

    @JsonProperty("offline")
    OFFLINE("offline", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private RiskDetectionTimingType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
