package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ResultantAppStateDetail implements Enum {

    @JsonProperty("processorArchitectureNotApplicable")
    PROCESSOR_ARCHITECTURE_NOT_APPLICABLE("processorArchitectureNotApplicable", "-1000"),

    @JsonProperty("minimumDiskSpaceNotMet")
    MINIMUM_DISK_SPACE_NOT_MET("minimumDiskSpaceNotMet", "-1001"),

    @JsonProperty("minimumOsVersionNotMet")
    MINIMUM_OS_VERSION_NOT_MET("minimumOsVersionNotMet", "-1002"),

    @JsonProperty("minimumPhysicalMemoryNotMet")
    MINIMUM_PHYSICAL_MEMORY_NOT_MET("minimumPhysicalMemoryNotMet", "-1003"),

    @JsonProperty("minimumLogicalProcessorCountNotMet")
    MINIMUM_LOGICAL_PROCESSOR_COUNT_NOT_MET("minimumLogicalProcessorCountNotMet", "-1004"),

    @JsonProperty("minimumCpuSpeedNotMet")
    MINIMUM_CPU_SPEED_NOT_MET("minimumCpuSpeedNotMet", "-1005"),

    @JsonProperty("platformNotApplicable")
    PLATFORM_NOT_APPLICABLE("platformNotApplicable", "-1006"),

    @JsonProperty("fileSystemRequirementNotMet")
    FILE_SYSTEM_REQUIREMENT_NOT_MET("fileSystemRequirementNotMet", "-1011"),

    @JsonProperty("registryRequirementNotMet")
    REGISTRY_REQUIREMENT_NOT_MET("registryRequirementNotMet", "-1012"),

    @JsonProperty("powerShellScriptRequirementNotMet")
    POWER_SHELL_SCRIPT_REQUIREMENT_NOT_MET("powerShellScriptRequirementNotMet", "-1013"),

    @JsonProperty("supersedingAppsNotApplicable")
    SUPERSEDING_APPS_NOT_APPLICABLE("supersedingAppsNotApplicable", "-1016"),

    @JsonProperty("noAdditionalDetails")
    NO_ADDITIONAL_DETAILS("noAdditionalDetails", "0"),

    @JsonProperty("dependencyFailedToInstall")
    DEPENDENCY_FAILED_TO_INSTALL("dependencyFailedToInstall", "1"),

    @JsonProperty("dependencyWithRequirementsNotMet")
    DEPENDENCY_WITH_REQUIREMENTS_NOT_MET("dependencyWithRequirementsNotMet", "2"),

    @JsonProperty("dependencyPendingReboot")
    DEPENDENCY_PENDING_REBOOT("dependencyPendingReboot", "3"),

    @JsonProperty("dependencyWithAutoInstallDisabled")
    DEPENDENCY_WITH_AUTO_INSTALL_DISABLED("dependencyWithAutoInstallDisabled", "4"),

    @JsonProperty("supersededAppUninstallFailed")
    SUPERSEDED_APP_UNINSTALL_FAILED("supersededAppUninstallFailed", "5"),

    @JsonProperty("supersededAppUninstallPendingReboot")
    SUPERSEDED_APP_UNINSTALL_PENDING_REBOOT("supersededAppUninstallPendingReboot", "6"),

    @JsonProperty("removingSupersededApps")
    REMOVING_SUPERSEDED_APPS("removingSupersededApps", "7"),

    @JsonProperty("iosAppStoreUpdateFailedToInstall")
    IOS_APP_STORE_UPDATE_FAILED_TO_INSTALL("iosAppStoreUpdateFailedToInstall", "1000"),

    @JsonProperty("vppAppHasUpdateAvailable")
    VPP_APP_HAS_UPDATE_AVAILABLE("vppAppHasUpdateAvailable", "1001"),

    @JsonProperty("userRejectedUpdate")
    USER_REJECTED_UPDATE("userRejectedUpdate", "1002"),

    @JsonProperty("uninstallPendingReboot")
    UNINSTALL_PENDING_REBOOT("uninstallPendingReboot", "1003"),

    @JsonProperty("supersedingAppsDetected")
    SUPERSEDING_APPS_DETECTED("supersedingAppsDetected", "1004"),

    @JsonProperty("supersededAppsDetected")
    SUPERSEDED_APPS_DETECTED("supersededAppsDetected", "1005"),

    @JsonProperty("seeInstallErrorCode")
    SEE_INSTALL_ERROR_CODE("seeInstallErrorCode", "2000"),

    @JsonProperty("autoInstallDisabled")
    AUTO_INSTALL_DISABLED("autoInstallDisabled", "3000"),

    @JsonProperty("managedAppNoLongerPresent")
    MANAGED_APP_NO_LONGER_PRESENT("managedAppNoLongerPresent", "3001"),

    @JsonProperty("userRejectedInstall")
    USER_REJECTED_INSTALL("userRejectedInstall", "3002"),

    @JsonProperty("userIsNotLoggedIntoAppStore")
    USER_IS_NOT_LOGGED_INTO_APP_STORE("userIsNotLoggedIntoAppStore", "3003"),

    @JsonProperty("untargetedSupersedingAppsDetected")
    UNTARGETED_SUPERSEDING_APPS_DETECTED("untargetedSupersedingAppsDetected", "3004"),

    @JsonProperty("appRemovedBySupersedence")
    APP_REMOVED_BY_SUPERSEDENCE("appRemovedBySupersedence", "3005"),

    @JsonProperty("seeUninstallErrorCode")
    SEE_UNINSTALL_ERROR_CODE("seeUninstallErrorCode", "4000"),

    @JsonProperty("pendingReboot")
    PENDING_REBOOT("pendingReboot", "5000"),

    @JsonProperty("installingDependencies")
    INSTALLING_DEPENDENCIES("installingDependencies", "5001"),

    @JsonProperty("contentDownloaded")
    CONTENT_DOWNLOADED("contentDownloaded", "5002");

    private final String name;
    private final String value;

    private ResultantAppStateDetail(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
