package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RequirementProvider implements Enum {

    @JsonProperty("user")
    USER("user", "0"),

    @JsonProperty("request")
    REQUEST("request", "1"),

    @JsonProperty("servicePrincipal")
    SERVICE_PRINCIPAL("servicePrincipal", "2"),

    @JsonProperty("v1ConditionalAccess")
    V1CONDITIONAL_ACCESS("v1ConditionalAccess", "3"),

    @JsonProperty("multiConditionalAccess")
    MULTI_CONDITIONAL_ACCESS("multiConditionalAccess", "4"),

    @JsonProperty("tenantSessionRiskPolicy")
    TENANT_SESSION_RISK_POLICY("tenantSessionRiskPolicy", "5"),

    @JsonProperty("accountCompromisePolicies")
    ACCOUNT_COMPROMISE_POLICIES("accountCompromisePolicies", "6"),

    @JsonProperty("v1ConditionalAccessDependency")
    V1CONDITIONAL_ACCESS_DEPENDENCY("v1ConditionalAccessDependency", "7"),

    @JsonProperty("v1ConditionalAccessPolicyIdRequested")
    V1CONDITIONAL_ACCESS_POLICY_ID_REQUESTED("v1ConditionalAccessPolicyIdRequested", "8"),

    @JsonProperty("mfaRegistrationRequiredByIdentityProtectionPolicy")
    MFA_REGISTRATION_REQUIRED_BY_IDENTITY_PROTECTION_POLICY("mfaRegistrationRequiredByIdentityProtectionPolicy", "9"),

    @JsonProperty("baselineProtection")
    BASELINE_PROTECTION("baselineProtection", "10"),

    @JsonProperty("mfaRegistrationRequiredByBaselineProtection")
    MFA_REGISTRATION_REQUIRED_BY_BASELINE_PROTECTION("mfaRegistrationRequiredByBaselineProtection", "11"),

    @JsonProperty("mfaRegistrationRequiredByMultiConditionalAccess")
    MFA_REGISTRATION_REQUIRED_BY_MULTI_CONDITIONAL_ACCESS("mfaRegistrationRequiredByMultiConditionalAccess", "12"),

    @JsonProperty("enforcedForCspAdmins")
    ENFORCED_FOR_CSP_ADMINS("enforcedForCspAdmins", "13"),

    @JsonProperty("securityDefaults")
    SECURITY_DEFAULTS("securityDefaults", "14"),

    @JsonProperty("mfaRegistrationRequiredBySecurityDefaults")
    MFA_REGISTRATION_REQUIRED_BY_SECURITY_DEFAULTS("mfaRegistrationRequiredBySecurityDefaults", "15"),

    @JsonProperty("proofUpCodeRequest")
    PROOF_UP_CODE_REQUEST("proofUpCodeRequest", "16"),

    @JsonProperty("crossTenantOutboundRule")
    CROSS_TENANT_OUTBOUND_RULE("crossTenantOutboundRule", "17"),

    @JsonProperty("gpsLocationCondition")
    GPS_LOCATION_CONDITION("gpsLocationCondition", "18"),

    @JsonProperty("riskBasedPolicy")
    RISK_BASED_POLICY("riskBasedPolicy", "19"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "20");

    private final String name;
    private final String value;

    private RequirementProvider(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
