package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RemoteAction implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("factoryReset")
    FACTORY_RESET("factoryReset", "1"),

    @JsonProperty("removeCompanyData")
    REMOVE_COMPANY_DATA("removeCompanyData", "2"),

    @JsonProperty("resetPasscode")
    RESET_PASSCODE("resetPasscode", "3"),

    @JsonProperty("remoteLock")
    REMOTE_LOCK("remoteLock", "4"),

    @JsonProperty("enableLostMode")
    ENABLE_LOST_MODE("enableLostMode", "5"),

    @JsonProperty("disableLostMode")
    DISABLE_LOST_MODE("disableLostMode", "6"),

    @JsonProperty("locateDevice")
    LOCATE_DEVICE("locateDevice", "7"),

    @JsonProperty("rebootNow")
    REBOOT_NOW("rebootNow", "8"),

    @JsonProperty("recoverPasscode")
    RECOVER_PASSCODE("recoverPasscode", "9"),

    @JsonProperty("cleanWindowsDevice")
    CLEAN_WINDOWS_DEVICE("cleanWindowsDevice", "10"),

    @JsonProperty("logoutSharedAppleDeviceActiveUser")
    LOGOUT_SHARED_APPLE_DEVICE_ACTIVE_USER("logoutSharedAppleDeviceActiveUser", "11"),

    @JsonProperty("quickScan")
    QUICK_SCAN("quickScan", "12"),

    @JsonProperty("fullScan")
    FULL_SCAN("fullScan", "13"),

    @JsonProperty("windowsDefenderUpdateSignatures")
    WINDOWS_DEFENDER_UPDATE_SIGNATURES("windowsDefenderUpdateSignatures", "14"),

    @JsonProperty("factoryResetKeepEnrollmentData")
    FACTORY_RESET_KEEP_ENROLLMENT_DATA("factoryResetKeepEnrollmentData", "15"),

    @JsonProperty("updateDeviceAccount")
    UPDATE_DEVICE_ACCOUNT("updateDeviceAccount", "16"),

    @JsonProperty("automaticRedeployment")
    AUTOMATIC_REDEPLOYMENT("automaticRedeployment", "17"),

    @JsonProperty("shutDown")
    SHUT_DOWN("shutDown", "18"),

    @JsonProperty("rotateBitLockerKeys")
    ROTATE_BIT_LOCKER_KEYS("rotateBitLockerKeys", "19"),

    @JsonProperty("rotateFileVaultKey")
    ROTATE_FILE_VAULT_KEY("rotateFileVaultKey", "20"),

    @JsonProperty("getFileVaultKey")
    GET_FILE_VAULT_KEY("getFileVaultKey", "21"),

    @JsonProperty("setDeviceName")
    SET_DEVICE_NAME("setDeviceName", "22"),

    @JsonProperty("activateDeviceEsim")
    ACTIVATE_DEVICE_ESIM("activateDeviceEsim", "23");

    private final String name;
    private final String value;

    private RemoteAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
