package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RemediationState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("skipped")
    SKIPPED("skipped", "1"),

    @JsonProperty("success")
    SUCCESS("success", "2"),

    @JsonProperty("remediationFailed")
    REMEDIATION_FAILED("remediationFailed", "3"),

    @JsonProperty("scriptError")
    SCRIPT_ERROR("scriptError", "4");

    private final String name;
    private final String value;

    private RemediationState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
