package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RegistryValueType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("binary")
    BINARY("binary", "1"),

    @JsonProperty("dword")
    DWORD("dword", "2"),

    @JsonProperty("dwordLittleEndian")
    DWORD_LITTLE_ENDIAN("dwordLittleEndian", "3"),

    @JsonProperty("dwordBigEndian")
    DWORD_BIG_ENDIAN("dwordBigEndian", "4"),

    @JsonProperty("expandSz")
    EXPAND_SZ("expandSz", "5"),

    @JsonProperty("link")
    LINK("link", "6"),

    @JsonProperty("multiSz")
    MULTI_SZ("multiSz", "7"),

    @JsonProperty("none")
    NONE("none", "8"),

    @JsonProperty("qword")
    QWORD("qword", "9"),

    @JsonProperty("qwordlittleEndian")
    QWORDLITTLE_ENDIAN("qwordlittleEndian", "10"),

    @JsonProperty("sz")
    SZ("sz", "11"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private RegistryValueType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
