package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RegistrationStatusType implements Enum {

    @JsonProperty("registered")
    REGISTERED("registered", "0"),

    @JsonProperty("enabled")
    ENABLED("enabled", "1"),

    @JsonProperty("capable")
    CAPABLE("capable", "2"),

    @JsonProperty("mfaRegistered")
    MFA_REGISTERED("mfaRegistered", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private RegistrationStatusType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
