package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RecommendationStatus implements Enum {

    @JsonProperty("active")
    ACTIVE("active", "0"),

    @JsonProperty("completedBySystem")
    COMPLETED_BY_SYSTEM("completedBySystem", "1"),

    @JsonProperty("completedByUser")
    COMPLETED_BY_USER("completedByUser", "2"),

    @JsonProperty("dismissed")
    DISMISSED("dismissed", "3"),

    @JsonProperty("postponed")
    POSTPONED("postponed", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private RecommendationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
