package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RecommendationCategory implements Enum {

    @JsonProperty("usageAndCompliance")
    USAGE_AND_COMPLIANCE("usageAndCompliance", "0"),

    @JsonProperty("security")
    SECURITY("security", "1"),

    @JsonProperty("productivity")
    PRODUCTIVITY("productivity", "2"),

    @JsonProperty("health")
    HEALTH("health", "3"),

    @JsonProperty("configuration")
    CONFIGURATION("configuration", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private RecommendationCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
