package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RatingGermanyMoviesType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("general")
    GENERAL("general", "2"),

    @JsonProperty("agesAbove6")
    AGES_ABOVE6("agesAbove6", "3"),

    @JsonProperty("agesAbove12")
    AGES_ABOVE12("agesAbove12", "4"),

    @JsonProperty("agesAbove16")
    AGES_ABOVE16("agesAbove16", "5"),

    @JsonProperty("adults")
    ADULTS("adults", "6");

    private final String name;
    private final String value;

    private RatingGermanyMoviesType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
