package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RatingAustraliaTelevisionType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("preschoolers")
    PRESCHOOLERS("preschoolers", "2"),

    @JsonProperty("children")
    CHILDREN("children", "3"),

    @JsonProperty("general")
    GENERAL("general", "4"),

    @JsonProperty("parentalGuidance")
    PARENTAL_GUIDANCE("parentalGuidance", "5"),

    @JsonProperty("mature")
    MATURE("mature", "6"),

    @JsonProperty("agesAbove15")
    AGES_ABOVE15("agesAbove15", "7"),

    @JsonProperty("agesAbove15AdultViolence")
    AGES_ABOVE15ADULT_VIOLENCE("agesAbove15AdultViolence", "8");

    private final String name;
    private final String value;

    private RatingAustraliaTelevisionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
