package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ProvisioningStatusErrorCategory implements Enum {

    @JsonProperty("failure")
    FAILURE("failure", "0"),

    @JsonProperty("nonServiceFailure")
    NON_SERVICE_FAILURE("nonServiceFailure", "1"),

    @JsonProperty("success")
    SUCCESS("success", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private ProvisioningStatusErrorCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
