package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ProvisioningAction implements Enum {

    @JsonProperty("other")
    OTHER("other", "0"),

    @JsonProperty("create")
    CREATE("create", "1"),

    @JsonProperty("delete")
    DELETE("delete", "2"),

    @JsonProperty("disable")
    DISABLE("disable", "3"),

    @JsonProperty("update")
    UPDATE("update", "4"),

    @JsonProperty("stagedDelete")
    STAGED_DELETE("stagedDelete", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private ProvisioningAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
