package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ProtocolType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("oAuth2")
    O_AUTH2("oAuth2", "1"),

    @JsonProperty("ropc")
    ROPC("ropc", "2"),

    @JsonProperty("wsFederation")
    WS_FEDERATION("wsFederation", "4"),

    @JsonProperty("saml20")
    SAML20("saml20", "8"),

    @JsonProperty("deviceCode")
    DEVICE_CODE("deviceCode", "16"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "32");

    private final String name;
    private final String value;

    private ProtocolType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
