package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PropertyType implements Enum {

    @JsonProperty("string")
    STRING("string", "0"),

    @JsonProperty("int64")
    INT64("int64", "1"),

    @JsonProperty("double")
    DOUBLE("double", "2"),

    @JsonProperty("dateTime")
    DATE_TIME("dateTime", "3"),

    @JsonProperty("boolean")
    BOOLEAN("boolean", "4"),

    @JsonProperty("stringCollection")
    STRING_COLLECTION("stringCollection", "5"),

    @JsonProperty("int64Collection")
    INT64COLLECTION("int64Collection", "6"),

    @JsonProperty("doubleCollection")
    DOUBLE_COLLECTION("doubleCollection", "7"),

    @JsonProperty("dateTimeCollection")
    DATE_TIME_COLLECTION("dateTimeCollection", "8");

    private final String name;
    private final String value;

    private PropertyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
