package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PromptLoginBehavior implements Enum {

    @JsonProperty("translateToFreshPasswordAuthentication")
    TRANSLATE_TO_FRESH_PASSWORD_AUTHENTICATION("translateToFreshPasswordAuthentication", "0"),

    @JsonProperty("nativeSupport")
    NATIVE_SUPPORT("nativeSupport", "1"),

    @JsonProperty("disabled")
    DISABLED("disabled", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private PromptLoginBehavior(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
