package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ProcessIntegrityLevel implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("untrusted")
    UNTRUSTED("untrusted", "1"),

    @JsonProperty("low")
    LOW("low", "2"),

    @JsonProperty("medium")
    MEDIUM("medium", "3"),

    @JsonProperty("high")
    HIGH("high", "4"),

    @JsonProperty("system")
    SYSTEM("system", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private ProcessIntegrityLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
