package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrintPresentationDirection implements Enum {

    @JsonProperty("clockwiseFromTopLeft")
    CLOCKWISE_FROM_TOP_LEFT("clockwiseFromTopLeft", "0"),

    @JsonProperty("counterClockwiseFromTopLeft")
    COUNTER_CLOCKWISE_FROM_TOP_LEFT("counterClockwiseFromTopLeft", "1"),

    @JsonProperty("counterClockwiseFromTopRight")
    COUNTER_CLOCKWISE_FROM_TOP_RIGHT("counterClockwiseFromTopRight", "2"),

    @JsonProperty("clockwiseFromTopRight")
    CLOCKWISE_FROM_TOP_RIGHT("clockwiseFromTopRight", "3"),

    @JsonProperty("counterClockwiseFromBottomLeft")
    COUNTER_CLOCKWISE_FROM_BOTTOM_LEFT("counterClockwiseFromBottomLeft", "4"),

    @JsonProperty("clockwiseFromBottomLeft")
    CLOCKWISE_FROM_BOTTOM_LEFT("clockwiseFromBottomLeft", "5"),

    @JsonProperty("counterClockwiseFromBottomRight")
    COUNTER_CLOCKWISE_FROM_BOTTOM_RIGHT("counterClockwiseFromBottomRight", "6"),

    @JsonProperty("clockwiseFromBottomRight")
    CLOCKWISE_FROM_BOTTOM_RIGHT("clockwiseFromBottomRight", "7");

    private final String name;
    private final String value;

    private PrintPresentationDirection(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
