package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrintJobProcessingState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("pending")
    PENDING("pending", "1"),

    @JsonProperty("processing")
    PROCESSING("processing", "2"),

    @JsonProperty("paused")
    PAUSED("paused", "3"),

    @JsonProperty("stopped")
    STOPPED("stopped", "4"),

    @JsonProperty("completed")
    COMPLETED("completed", "5"),

    @JsonProperty("canceled")
    CANCELED("canceled", "6"),

    @JsonProperty("aborted")
    ABORTED("aborted", "7");

    private final String name;
    private final String value;

    private PrintJobProcessingState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
