package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PlannerPreviewType implements Enum {

    @JsonProperty("automatic")
    AUTOMATIC("automatic", "0"),

    @JsonProperty("noPreview")
    NO_PREVIEW("noPreview", "1"),

    @JsonProperty("checklist")
    CHECKLIST("checklist", "2"),

    @JsonProperty("description")
    DESCRIPTION("description", "3"),

    @JsonProperty("reference")
    REFERENCE("reference", "4");

    private final String name;
    private final String value;

    private PlannerPreviewType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
