package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PlannerPlanContextType implements Enum {

    @JsonProperty("teamsTab")
    TEAMS_TAB("teamsTab", "1"),

    @JsonProperty("sharePointPage")
    SHARE_POINT_PAGE("sharePointPage", "2"),

    @JsonProperty("meetingNotes")
    MEETING_NOTES("meetingNotes", "3"),

    @JsonProperty("other")
    OTHER("other", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private PlannerPlanContextType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
