package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PersonRelationship implements Enum {

    @JsonProperty("manager")
    MANAGER("manager", "0"),

    @JsonProperty("colleague")
    COLLEAGUE("colleague", "1"),

    @JsonProperty("directReport")
    DIRECT_REPORT("directReport", "2"),

    @JsonProperty("dotLineReport")
    DOT_LINE_REPORT("dotLineReport", "3"),

    @JsonProperty("assistant")
    ASSISTANT("assistant", "4"),

    @JsonProperty("dotLineManager")
    DOT_LINE_MANAGER("dotLineManager", "5"),

    @JsonProperty("alternateContact")
    ALTERNATE_CONTACT("alternateContact", "6"),

    @JsonProperty("friend")
    FRIEND("friend", "7"),

    @JsonProperty("spouse")
    SPOUSE("spouse", "8"),

    @JsonProperty("sibling")
    SIBLING("sibling", "9"),

    @JsonProperty("child")
    CHILD("child", "10"),

    @JsonProperty("parent")
    PARENT("parent", "11"),

    @JsonProperty("sponsor")
    SPONSOR("sponsor", "12"),

    @JsonProperty("emergencyContact")
    EMERGENCY_CONTACT("emergencyContact", "13"),

    @JsonProperty("other")
    OTHER("other", "14"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "15");

    private final String name;
    private final String value;

    private PersonRelationship(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
