package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OperatingSystemUpgradeEligibility implements Enum {

    @JsonProperty("upgraded")
    UPGRADED("upgraded", "0"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "1"),

    @JsonProperty("notCapable")
    NOT_CAPABLE("notCapable", "2"),

    @JsonProperty("capable")
    CAPABLE("capable", "3");

    private final String name;
    private final String value;

    private OperatingSystemUpgradeEligibility(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
