package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OnenoteSourceService implements Enum {

    @JsonProperty("Unknown")
    UNKNOWN("Unknown", "0"),

    @JsonProperty("OneDrive")
    ONE_DRIVE("OneDrive", "1"),

    @JsonProperty("OneDriveForBusiness")
    ONE_DRIVE_FOR_BUSINESS("OneDriveForBusiness", "2"),

    @JsonProperty("OnPremOneDriveForBusiness")
    ON_PREM_ONE_DRIVE_FOR_BUSINESS("OnPremOneDriveForBusiness", "3");

    private final String name;
    private final String value;

    private OnenoteSourceService(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
