package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OnboardingStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("inprogress")
    INPROGRESS("inprogress", "1"),

    @JsonProperty("onboarded")
    ONBOARDED("onboarded", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3"),

    @JsonProperty("offboarding")
    OFFBOARDING("offboarding", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "99");

    private final String name;
    private final String value;

    private OnboardingStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
