package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OnPremisesPublishingType implements Enum {

    @JsonProperty("applicationProxy")
    APPLICATION_PROXY("applicationProxy", "0"),

    @JsonProperty("exchangeOnline")
    EXCHANGE_ONLINE("exchangeOnline", "1"),

    @JsonProperty("authentication")
    AUTHENTICATION("authentication", "2"),

    @JsonProperty("provisioning")
    PROVISIONING("provisioning", "3"),

    @JsonProperty("intunePfx")
    INTUNE_PFX("intunePfx", "4"),

    @JsonProperty("oflineDomainJoin")
    OFLINE_DOMAIN_JOIN("oflineDomainJoin", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private OnPremisesPublishingType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
