package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum NonEapAuthenticationMethodForPeap implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("microsoftChapVersionTwo")
    MICROSOFT_CHAP_VERSION_TWO("microsoftChapVersionTwo", "1");

    private final String name;
    private final String value;

    private NonEapAuthenticationMethodForPeap(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
