package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum NonEapAuthenticationMethodForEapTtlsType implements Enum {

    @JsonProperty("unencryptedPassword")
    UNENCRYPTED_PASSWORD("unencryptedPassword", "0"),

    @JsonProperty("challengeHandshakeAuthenticationProtocol")
    CHALLENGE_HANDSHAKE_AUTHENTICATION_PROTOCOL("challengeHandshakeAuthenticationProtocol", "1"),

    @JsonProperty("microsoftChap")
    MICROSOFT_CHAP("microsoftChap", "2"),

    @JsonProperty("microsoftChapVersionTwo")
    MICROSOFT_CHAP_VERSION_TWO("microsoftChapVersionTwo", "3");

    private final String name;
    private final String value;

    private NonEapAuthenticationMethodForEapTtlsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
