package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum NdesConnectorState implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("active")
    ACTIVE("active", "1"),

    @JsonProperty("inactive")
    INACTIVE("inactive", "2");

    private final String name;
    private final String value;

    private NdesConnectorState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
