package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MobileAppPublishingState implements Enum {

    @JsonProperty("notPublished")
    NOT_PUBLISHED("notPublished", "0"),

    @JsonProperty("processing")
    PROCESSING("processing", "1"),

    @JsonProperty("published")
    PUBLISHED("published", "2");

    private final String name;
    private final String value;

    private MobileAppPublishingState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
