package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MobileAppDependencyType implements Enum {

    @JsonProperty("detect")
    DETECT("detect", "0"),

    @JsonProperty("autoInstall")
    AUTO_INSTALL("autoInstall", "1");

    private final String name;
    private final String value;

    private MobileAppDependencyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
