package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MobileAppContentFileUploadState implements Enum {

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("transientError")
    TRANSIENT_ERROR("transientError", "1"),

    @JsonProperty("error")
    ERROR("error", "2"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "3"),

    @JsonProperty("azureStorageUriRequestSuccess")
    AZURE_STORAGE_URI_REQUEST_SUCCESS("azureStorageUriRequestSuccess", "100"),

    @JsonProperty("azureStorageUriRequestPending")
    AZURE_STORAGE_URI_REQUEST_PENDING("azureStorageUriRequestPending", "101"),

    @JsonProperty("azureStorageUriRequestFailed")
    AZURE_STORAGE_URI_REQUEST_FAILED("azureStorageUriRequestFailed", "102"),

    @JsonProperty("azureStorageUriRequestTimedOut")
    AZURE_STORAGE_URI_REQUEST_TIMED_OUT("azureStorageUriRequestTimedOut", "103"),

    @JsonProperty("azureStorageUriRenewalSuccess")
    AZURE_STORAGE_URI_RENEWAL_SUCCESS("azureStorageUriRenewalSuccess", "200"),

    @JsonProperty("azureStorageUriRenewalPending")
    AZURE_STORAGE_URI_RENEWAL_PENDING("azureStorageUriRenewalPending", "201"),

    @JsonProperty("azureStorageUriRenewalFailed")
    AZURE_STORAGE_URI_RENEWAL_FAILED("azureStorageUriRenewalFailed", "202"),

    @JsonProperty("azureStorageUriRenewalTimedOut")
    AZURE_STORAGE_URI_RENEWAL_TIMED_OUT("azureStorageUriRenewalTimedOut", "203"),

    @JsonProperty("commitFileSuccess")
    COMMIT_FILE_SUCCESS("commitFileSuccess", "300"),

    @JsonProperty("commitFilePending")
    COMMIT_FILE_PENDING("commitFilePending", "301"),

    @JsonProperty("commitFileFailed")
    COMMIT_FILE_FAILED("commitFileFailed", "302"),

    @JsonProperty("commitFileTimedOut")
    COMMIT_FILE_TIMED_OUT("commitFileTimedOut", "303");

    private final String name;
    private final String value;

    private MobileAppContentFileUploadState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
