package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MobileAppActionType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("installCommandSent")
    INSTALL_COMMAND_SENT("installCommandSent", "1"),

    @JsonProperty("installed")
    INSTALLED("installed", "3"),

    @JsonProperty("uninstalled")
    UNINSTALLED("uninstalled", "4"),

    @JsonProperty("userRequestedInstall")
    USER_REQUESTED_INSTALL("userRequestedInstall", "5");

    private final String name;
    private final String value;

    private MobileAppActionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
