package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MessageEventType implements Enum {

    @JsonProperty("received")
    RECEIVED("received", "1"),

    @JsonProperty("sent")
    SENT("sent", "2"),

    @JsonProperty("delivered")
    DELIVERED("delivered", "3"),

    @JsonProperty("failed")
    FAILED("failed", "4"),

    @JsonProperty("processingFailed")
    PROCESSING_FAILED("processingFailed", "5"),

    @JsonProperty("distributionGroupExpanded")
    DISTRIBUTION_GROUP_EXPANDED("distributionGroupExpanded", "6"),

    @JsonProperty("submitted")
    SUBMITTED("submitted", "7"),

    @JsonProperty("delayed")
    DELAYED("delayed", "8"),

    @JsonProperty("redirected")
    REDIRECTED("redirected", "9"),

    @JsonProperty("resolved")
    RESOLVED("resolved", "10"),

    @JsonProperty("dropped")
    DROPPED("dropped", "11"),

    @JsonProperty("recipientsAdded")
    RECIPIENTS_ADDED("recipientsAdded", "12"),

    @JsonProperty("malwareDetected")
    MALWARE_DETECTED("malwareDetected", "13"),

    @JsonProperty("malwareDetectedInMessage")
    MALWARE_DETECTED_IN_MESSAGE("malwareDetectedInMessage", "14"),

    @JsonProperty("malwareDetectedInAttachment")
    MALWARE_DETECTED_IN_ATTACHMENT("malwareDetectedInAttachment", "15"),

    @JsonProperty("ttZapped")
    TT_ZAPPED("ttZapped", "16"),

    @JsonProperty("ttDelivered")
    TT_DELIVERED("ttDelivered", "17"),

    @JsonProperty("spamDetected")
    SPAM_DETECTED("spamDetected", "18"),

    @JsonProperty("transportRuleTriggered")
    TRANSPORT_RULE_TRIGGERED("transportRuleTriggered", "19"),

    @JsonProperty("dlpRuleTriggered")
    DLP_RULE_TRIGGERED("dlpRuleTriggered", "20"),

    @JsonProperty("journaled")
    JOURNALED("journaled", "21"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "22");

    private final String name;
    private final String value;

    private MessageEventType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
