package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MessageActionFlag implements Enum {

    @JsonProperty("any")
    ANY("any", "0"),

    @JsonProperty("call")
    CALL("call", "1"),

    @JsonProperty("doNotForward")
    DO_NOT_FORWARD("doNotForward", "2"),

    @JsonProperty("followUp")
    FOLLOW_UP("followUp", "3"),

    @JsonProperty("fyi")
    FYI("fyi", "4"),

    @JsonProperty("forward")
    FORWARD("forward", "5"),

    @JsonProperty("noResponseNecessary")
    NO_RESPONSE_NECESSARY("noResponseNecessary", "6"),

    @JsonProperty("read")
    READ("read", "7"),

    @JsonProperty("reply")
    REPLY("reply", "8"),

    @JsonProperty("replyToAll")
    REPLY_TO_ALL("replyToAll", "9"),

    @JsonProperty("review")
    REVIEW("review", "10");

    private final String name;
    private final String value;

    private MessageActionFlag(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
