package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MeetingMessageType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("meetingRequest")
    MEETING_REQUEST("meetingRequest", "1"),

    @JsonProperty("meetingCancelled")
    MEETING_CANCELLED("meetingCancelled", "2"),

    @JsonProperty("meetingAccepted")
    MEETING_ACCEPTED("meetingAccepted", "3"),

    @JsonProperty("meetingTentativelyAccepted")
    MEETING_TENTATIVELY_ACCEPTED("meetingTentativelyAccepted", "4"),

    @JsonProperty("meetingDeclined")
    MEETING_DECLINED("meetingDeclined", "5");

    private final String name;
    private final String value;

    private MeetingMessageType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
