package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagementAgentType implements Enum {

    @JsonProperty("eas")
    EAS("eas", "1"),

    @JsonProperty("mdm")
    MDM("mdm", "2"),

    @JsonProperty("easMdm")
    EAS_MDM("easMdm", "3"),

    @JsonProperty("intuneClient")
    INTUNE_CLIENT("intuneClient", "4"),

    @JsonProperty("easIntuneClient")
    EAS_INTUNE_CLIENT("easIntuneClient", "5"),

    @JsonProperty("configurationManagerClient")
    CONFIGURATION_MANAGER_CLIENT("configurationManagerClient", "8"),

    @JsonProperty("configurationManagerClientMdm")
    CONFIGURATION_MANAGER_CLIENT_MDM("configurationManagerClientMdm", "10"),

    @JsonProperty("configurationManagerClientMdmEas")
    CONFIGURATION_MANAGER_CLIENT_MDM_EAS("configurationManagerClientMdmEas", "11"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "16"),

    @JsonProperty("jamf")
    JAMF("jamf", "32"),

    @JsonProperty("googleCloudDevicePolicyController")
    GOOGLE_CLOUD_DEVICE_POLICY_CONTROLLER("googleCloudDevicePolicyController", "64"),

    @JsonProperty("microsoft365ManagedMdm")
    MICROSOFT365MANAGED_MDM("microsoft365ManagedMdm", "258"),

    @JsonProperty("msSense")
    MS_SENSE("msSense", "1024"),

    @JsonProperty("intuneAosp")
    INTUNE_AOSP("intuneAosp", "2048");

    private final String name;
    private final String value;

    private ManagementAgentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
