package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedDeviceArchitecture implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("x86")
    X86("x86", "1"),

    @JsonProperty("x64")
    X64("x64", "2"),

    @JsonProperty("arm")
    ARM("arm", "3"),

    @JsonProperty("arM64")
    AR_M64("arM64", "4");

    private final String name;
    private final String value;

    private ManagedDeviceArchitecture(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
