package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedAppFlaggedReason implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("rootedDevice")
    ROOTED_DEVICE("rootedDevice", "1"),

    @JsonProperty("androidBootloaderUnlocked")
    ANDROID_BOOTLOADER_UNLOCKED("androidBootloaderUnlocked", "2"),

    @JsonProperty("androidFactoryRomModified")
    ANDROID_FACTORY_ROM_MODIFIED("androidFactoryRomModified", "3");

    private final String name;
    private final String value;

    private ManagedAppFlaggedReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
