package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedAppClipboardSharingLevel implements Enum {

    @JsonProperty("allApps")
    ALL_APPS("allApps", "0"),

    @JsonProperty("managedAppsWithPasteIn")
    MANAGED_APPS_WITH_PASTE_IN("managedAppsWithPasteIn", "1"),

    @JsonProperty("managedApps")
    MANAGED_APPS("managedApps", "2"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "3");

    private final String name;
    private final String value;

    private ManagedAppClipboardSharingLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
