package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSSoftwareUpdateState implements Enum {

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("downloading")
    DOWNLOADING("downloading", "1000"),

    @JsonProperty("downloaded")
    DOWNLOADED("downloaded", "1001"),

    @JsonProperty("installing")
    INSTALLING("installing", "1002"),

    @JsonProperty("idle")
    IDLE("idle", "1003"),

    @JsonProperty("available")
    AVAILABLE("available", "1004"),

    @JsonProperty("scheduled")
    SCHEDULED("scheduled", "1005"),

    @JsonProperty("downloadFailed")
    DOWNLOAD_FAILED("downloadFailed", "2000"),

    @JsonProperty("downloadInsufficientSpace")
    DOWNLOAD_INSUFFICIENT_SPACE("downloadInsufficientSpace", "2001"),

    @JsonProperty("downloadInsufficientPower")
    DOWNLOAD_INSUFFICIENT_POWER("downloadInsufficientPower", "2002"),

    @JsonProperty("downloadInsufficientNetwork")
    DOWNLOAD_INSUFFICIENT_NETWORK("downloadInsufficientNetwork", "2003"),

    @JsonProperty("installInsufficientSpace")
    INSTALL_INSUFFICIENT_SPACE("installInsufficientSpace", "2004"),

    @JsonProperty("installInsufficientPower")
    INSTALL_INSUFFICIENT_POWER("installInsufficientPower", "2005"),

    @JsonProperty("installFailed")
    INSTALL_FAILED("installFailed", "2006"),

    @JsonProperty("commandFailed")
    COMMAND_FAILED("commandFailed", "2007");

    private final String name;
    private final String value;

    private MacOSSoftwareUpdateState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
